/*
  file: crusade_script_defs.h
  purpose: Object datablock definitions

  Author: David Grace
  Creation: 08/04/2002


*/

typedef struct tobjdef {

  void *object ; // which object we are a part of

  int x, y ;     // basic positional information
  float fx, fy ; // high-quality float representations of position (used only for angle calcs)

  unsigned char angle ;

  
  int len_x, len_y, dx, dy, offset_x, offset_y ;
  int type ;
  int sub_type ;

  int hitpoints ;
  int damagepoints ;
  int removeable ;
  int power_up ;
  int hurt ;
  int state ;
  int score ;


  int priority ; // Display priority
  int timer ;  // internal timer (counts up as long as object exists)

  // type information
  int is_enemy  ;    // defined as "enemy" group
  int is_player ;    // defined as "player" group
  int is_bullet ;


  // collision detection information
  int cd_enable ;       // TRUE/FALSE
  int cd_hurtenemy ;    // does this hurt another enemy-class object?
  int cd_hurtplayer ;   // does this hurt another player-class object?
  int cd_map ;          // can this collide with the tilemap?

  // state variables, define them as you wish
  int var[10] ; 
  
  // child object pointers
  void *child[10] ;

	// animation information
	int animation ;               // animation pool index, set to -1 for none
	int ani_curr_frame ;          // index in frame pool
	int ani_time ;                // timer for next frame count
	int ani_effect ;              // effect to apply to animation (see ANIEFFECT_xxxxxx)


  // only defined for the player object
  int has_control ;             // allows the player to control the object
  
  int clangsnd ;

} tobjdef ;

#define REASON_TIMEOUT             1 // CanRemove function returned TRUE
#define REASON_CDKILL              2 // Collision detection has occurred and remove requested

// define animation priorities (higher means on top)
// Player priority set to 50000
#define BULLET_PRIORITY            600
#define ENEMY_PRIORITY						 500
#define BACKGROUND_PRIORITY        100  

// animation effects
#define ANIEFFECT_NONE						 0 // no effect applied
#define ANIEFFECT_WHITE            1 // change sprite to white


// particle definitions
#define  PARTICLETYPE_DOT          1 // typical plasma dot :)
#define  PARTICLETYPE_FLARE        2 // large red-glow flare
#define  PARTICLETYPE_FLARE2       3 // small blue-glow flare
#define  PARTICLETYPE_SMOKEBALL    4 // fair-sized billowing smoke ball
#define  PARTICLETYPE_PUFF         5 // small puff of smoke
#define  PARTICLETYPE_DOTGREEN     6 // green plasma dot
#define  PARTICLETYPE_BIGEXP       7 // giant boss-sized explosion
#define  PARTICLETYPE_ENGINEPUFF   8 // larger exhaust puff of smoke
#define  PARTICLETYPE_SMALLPUFF    9 // same as PUFF, but smaller size
#define  PARTICLETYPE_FASTDOT     10 // just like DOT, but shorter life


// level events
#define  LEVELEVENT_ADD            1 // add an object
#define  LEVELEVENT_SCRIPT         2 // calls a script function from scripts.cs
#define  LEVELEVENT_CHECKPT        3 // Sets a continue checkpoint (for dying)
#define  LEVELEVENT_CONV           4 // calls a conversation event
#define  LEVELEVENT_BOSS           5 // creates and monitors a boss

// player bullet types
#define  BULLET_TYPE0              0 // standard, fires upwards

// enemy bullet
#define  ENEMYBULLET_TYPE0        10 // standard enemy bullet
#define  ENEMYBULLET_TYPE1        11 
